const Sequelize = require('sequelize');
module.exports = function (sequelize, DataTypes) {
    return sequelize.define('tbl_ds_binding', {
        id: {
            type: DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true,
            autoIncrement: true
        },
        DS_NUMBER: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: null
        },
        TAB_IP: {
            type: DataTypes.STRING(20),
            allowNull: true,
            defaultValue: null
        },
        UserID: {
            type: DataTypes.STRING(50),
            allowNull: true,
            defaultValue: null
        },
        PortNo: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: null
        },
        CreatedDate: {
            type: DataTypes.DATE,
            allowNull: false,
            defaultValue: Sequelize.Sequelize.literal('CURRENT_TIMESTAMP')
        },
        MenuName: {
            type: DataTypes.STRING(50),
            allowNull: true,
            defaultValue: null
        }
    }, {
        sequelize,
        tableName: 'tbl_ds_binding',
        timestamps: false,
        indexes: [
            {
                name: "PRIMARY",
                unique: true,
                using: "BTREE",
                fields: [
                    { name: "id" },
                ]
            },
        ]
    });
};
